<?php $__env->startSection('breadcrumb'); ?>
<li>
	<a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Créditos</li>
<li>Juros de Mora</li>
<li class="active">
	<strong>Pagar Juros de Mora</strong>
</li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="row">
	<?php if(isset($emp)): ?>
		<div class="col-md-12">
			<a  href="<?php echo e(route('emprestimo.juros')); ?>" class="btn btn-info">
				<i class="entypo-to-start"></i> Voltar
			</a> <br><br>	
		</div>
	<?php endif; ?>	
	<div class="col-md-12">	
		<?php echo $__env->make('layout.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <form role="form" class="form-horizontal" method="post" action="<?php echo e(route('movimento.store')); ?>" enctype="multipart/form-data">
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong><?php echo e($title); ?></strong>
				</div>
			</div>			
			<div class="panel-body">				
					
				<?php echo csrf_field(); ?>


				<input type="hidden" name="origem" value="JM">
				<input type="hidden" name="users_id" value="<?php echo e(auth()->user()->id); ?>">
				<input type="hidden" name="datasistema" value="<?php echo e(date("Y-m-d H:i:s")); ?>">
				<input type="hidden" name="hora" value="<?php echo e(date("H:i:s")); ?>">
				<input type="hidden" name="idplanoamort" value="<?php echo e($emp->idplanoamort); ?>">
				<input type="hidden" id="idamort" value="<?php echo e($emp->idamort); ?>">	
				<input type="hidden" id="datapagar"  value="<?php echo e($emp->datapagar); ?>">			
				<div class="row">
					<div class="col-md-6">
						<div class="col-md-12">
							<div class="form-group has-info">
								<label class="control-label col-md-12">Valor da Prestação</label>
								<div class="col-md-12">
									<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valorprestacao" value="<?php echo e($emp->valorprestacao ?? 0); ?>" readonly >
								</div>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group has-info">
								<label class="control-label col-md-12">Data de Pagamento</label>
								<div class="col-md-12">
									<input type="date" id="datamov" name="datamov" class="form-control" value="<?php echo e(date("Y-m-d")); ?>" required>
								</div>
							</div>
						</div>
					</div>	
					<div class="col-md-6">
						<div class="col-md-12">
							<div class="form-group has-info">
								<label class="control-label col-md-12">Juros de Mora</label>
								<div class="col-md-12">
									<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="jurosmora" value="<?php echo e(number_format((0.1/$emp->prestacoes*$emp->valortotal),2)); ?>" readonly >
								</div>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group has-info">
								<label class="control-label col-md-12">Valor Pago</label>
								<div class="col-md-12">
									<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valor" name="valor" required onblur="formataCampo()" >
								</div>
							</div>
						</div>
					</div>					
				</div>						
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<script>
	function formataCampo(){
		var valorpago = $('#valor').val();
		valorpago     = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(valorpago);
		$('#valor').val(valorpago);
	}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp73\htdocs\smartechmz\smarcredito\resources\views/movimento/pagamentojuros.blade.php ENDPATH**/ ?>