<?php $__env->startSection('breadcrumb'); ?>
<li>
	<a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i>Dashboard</a>
</li>
<li>Créditos</li>
<li class="active">
	<strong>Novo Crédito</strong>
</li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="row">
	<?php if(isset($emp)): ?>
		<div class="col-md-12">
			<a  href="<?php echo e(route('emprestimo.expedicao')); ?>" class="btn btn-info">
				<i class="entypo-to-start"></i> Voltar
			</a> <br><br>	
		</div>
	<?php endif; ?>	
	<div class="col-md-12">	
		<?php echo $__env->make('layout.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <form role="form" class="form-horizontal" method="post" action="<?php echo e(route('movimento.store')); ?>" enctype="multipart/form-data">
		<div class="panel panel-primary" data-collapsed="0">		
			<div class="panel-heading ">
				<div class="panel-title">
					<strong><?php echo e($title); ?></strong>
				</div>
			</div>			
			<div class="panel-body">				
					
				<?php echo csrf_field(); ?>


				<input type="hidden" name="origem" value="PST">
				<input type="hidden" name="users_id" value="<?php echo e(auth()->user()->id); ?>">
				<input type="hidden" name="datasistema" value="<?php echo e(date("Y-m-d H:i:s")); ?>">
				<input type="hidden" name="hora" value="<?php echo e(date("H:i:s")); ?>">
				<input type="hidden" name="idplanoamort" value="<?php echo e($emp->idplanoamort); ?>">
				<input type="hidden" id="idamort" value="<?php echo e($emp->idamort); ?>">	
				<input type="hidden" id="datapagar"  value="<?php echo e($emp->datapagar); ?>">			
				<div class="row">
					<div class="col-md-6">
						<div class="col-md-12">
							<div class="form-group has-info">
								<label class="control-label col-md-12">Valor a Pagar</label>
								<div class="col-md-12">
									<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valorpagar" value="<?php echo e($emp->ppagar ?? 0); ?>" readonly >
								</div>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group has-info">
								<label class="control-label col-md-12">Data de Pagamento</label>
								<div class="col-md-12">
									<input type="date" id="datamov" name="datamov" class="form-control" value="<?php echo e(date("Y-m-d")); ?>" required onblur="calcularJuros()" >
								</div>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group has-info">
								<label class="control-label col-md-12">Valor Pago</label>
								<div class="col-md-12">
									<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valor" name="valor" value="<?php echo e($emp->ppagar ?? 0); ?>" required >
								</div>
							</div>
						</div>
					</div>	
					<div class="col-md-6">
						<div class="col-md-12">
							<div class="form-group has-info">
								<label class="control-label col-md-12">Valor da Prestação</label>
								<div class="col-md-12">
									<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="valorprestacao" value="<?php echo e($emp->ppagar ?? 0); ?>" readonly >
								</div>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group has-info">
								<label class="control-label col-md-12">Juros de Mora</label>
								<div class="col-md-12">
									<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="jurosmora" readonly >
								</div>
							</div>
						</div>
						<div class="col-md-12">
							<div class="form-group has-info">
								<label class="control-label col-md-12">Total a Pagar</label>
								<div class="col-md-12">
									<input type="text" data-mask="fdecimal" data-numeric-align="left" data-dec="," data-rad="." maxlength="30" class="form-control" id="totalp" readonly >
								</div>
							</div>
						</div>
					</div>					
				</div>						
			</div>
			<div class="panel-footer">
				<button type="submit" id="gravar" class="btn btn-success">
					<i class="fa fa-save"></i> Gravar
				</button>    
			</div>
			</form>	
		</div>
	
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
	$(document).ready(function(){
		calcularJuros();
	});
	function calcularJuros(){
		var jm         = 0;
		var total      = 0;
		var prestacoes = 0;
		var valortotal = 0;
		var idamort    = $('#idamort').val();
		var datae      = $('#datapagar').val();;
		var valorpagar = $('#valorpagar').val().replace(',','');
		prestacoes     = <?php echo e($emp->prestacoes); ?>;
		valortotal     = <?php echo e($emp->valortotal); ?>;

		//Se for Prestação Diária
		if(idamort!=1){
			if($('#datamov').val()>datae){
				//jm = Math.round($('#vtotal').val()*0.05);
				jm = (0.1/prestacoes)*valortotal;
				total = parseFloat(jm)+parseFloat(valorpagar);
				jm = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(jm);
				$('#jurosmora').val(jm);
				//$('#totalp').val(parseFloat(jm)+parseFloat($('#valorp').val()));
			}else{
				$('#jurosmora').val(jm);
				total = parseFloat(valorpagar);
				//$('#totalp').val(parseFloat($('#valorp').val()));
			}
		}else{
			$('#jurosmora').val(jm);
			total = parseFloat(valorpagar);
			//$('#totalp').val(parseFloat($('#valorp').val()));
		}
		total = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(total);
		$('#totalp').val(total);

	}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp73\htdocs\smartechmz\smarcredito\resources\views/movimento/pagamento.blade.php ENDPATH**/ ?>